% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model_OrdCont_copula.R
\name{fit_copula_submodel_OrdCont}
\alias{fit_copula_submodel_OrdCont}
\title{Fit ordinal-continuous copula submodel}
\usage{
fit_copula_submodel_OrdCont(
  X,
  Y,
  copula_family,
  marginal_Y,
  start_Y,
  start_copula,
  method = "BFGS",
  K,
  names_XY = c("Surr", "True"),
  twostep = FALSE,
  ...
)
}
\arguments{
\item{X}{First variable (Ordinal with \eqn{K} categories)}

\item{Y}{Second variable (Continuous)}

\item{copula_family}{Copula family, one of the following:
\itemize{
\item \code{"clayton"}
\item \code{"frank"}
\item \code{"gumbel"}
\item \code{"gaussian"}
}}

\item{marginal_Y}{List with the following five elements (in order):
\itemize{
\item Density function with first argument \code{x} and second argument \code{para} the parameter
vector for this distribution.
\item Distribution function with first argument \code{x} and second argument \code{para}.
\item Inverse distribution function with first argument \code{p} and second argument \code{para}.
\item The number of elements in \code{para}.
\item Starting values for \code{para}.
}}

\item{start_Y}{Starting values for the marginal distribution paramters for \code{Y}.}

\item{start_copula}{Starting value for the copula parameter.}

\item{method}{Optimization algorithm for maximizing the objective function.
For all options, see \code{?maxLik::maxLik}. Defaults to \code{"BFGS"}.}

\item{K}{Number of categories in \code{X}.}

\item{names_XY}{Names for \code{X} and \code{Y}, respectively.}

\item{twostep}{(boolean) If \code{TRUE}, the starting values are fixed for the
marginal distributions and only the copula parameter is estimated.}

\item{...}{Extra argument to pass onto maxLik::maxLik}
}
\value{
A list with five elements:
\itemize{
\item ml_fit: object of class \code{maxLik::maxLik} that contains the estimated copula
model.
\item marginal_X: list with the estimated cdf, pdf/pmf, and inverse cdf for X.
\item marginal_Y: list with the estimated cdf, pdf/pmf, and inverse cdf for X.
\item copula_family: string that indicates the copula family
\item data: data frame containing \code{X} and \code{Y}
\item names_XY: The names (i.e., \code{"Surr"} and \code{"True"}) for \code{X} and \code{Y}
}
}
\description{
The \code{fit_copula_submodel_OrdCont()} function fits the copula (sub)model for a
continuous surrogate and an ordinal true endpoint with maximum likelihood.
}
\seealso{
\code{\link[=ordinal_continuous_loglik]{ordinal_continuous_loglik()}}
}
