% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{KoreanBoneDensity_df}
\alias{KoreanBoneDensity_df}
\title{Bone quality in South Koreans}
\format{
A data frame with 969 observations and 7 variables:
\describe{
  \item{Sex}{Sex of the subject (factor with 2 levels)}
  \item{Age}{Age of the subject in years (integer)}
  \item{Height}{Height of the subject in centimeters (numeric)}
  \item{Weight}{Weight of the subject in kilograms (numeric)}
  \item{LumbarBMD}{Bone mass density at the lumbar spine (numeric)}
  \item{HipBMD}{Bone mass density at the hip (numeric)}
  \item{NeckBMD}{Bone mass density at the neck (numeric)}
}
}
\source{
Data taken from the \pkg{SRMData} package version 1.0.1
}
\usage{
data(KoreanBoneDensity_df)
}
\description{
This dataset, KoreanBoneDensity_df, is a data frame containing bone mass density measurements
of South Korean subjects at three body locations. It includes demographic information such as
sex, age, height, and weight, along with bone mass density values for the lumbar spine, hip, and neck.
}
\details{
The dataset name has been kept as 'KoreanBoneDensity_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
SouthKoreAPIs package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame object. The original content has not been modified
in any way.
}
