% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SmartSVA.R
\name{smartsva}
\alias{smartsva}
\title{Performs a significantly more efficient surrogate variable analysis for EWAS.}
\usage{
smartsva(dat, mod, mod0 = NULL, n.sv, B = 100, alpha = 0.25,
  epsilon = 0.001, VERBOSE = F)
}
\arguments{
\item{dat}{the measurement matrix (preferably M-values)
where rows are variables and columns are samples.}

\item{mod}{the model matrix used to fit data.}

\item{mod0}{contains the nul model matrix.}

\item{n.sv}{number of svs. The use of random matrix theory is recommended to estimate
n.sv. See the example for more details.}

\item{B}{iteration number which is typically varies between 20 and 100.}

\item{alpha}{determines the initial point for optimization
which affects the convergence rate.}

\item{epsilon}{specifies the convergence threshold. the spearman
correlation between posterior probabilities of consecutive iterations
of the algorithm is compared to epsilon. Empirical evaluation on several
dataset revealed epsilon=0.005 gives very reasonable results.
However, we suggest epsilon=1e-3 as a conservative threshold.}

\item{VERBOSE}{a logical variable. If TRUE, prints some details about
iterative progress of the algorithm.}
}
\value{
Returs a list containing the surrogate variables and some meta data
about the convergence criterion.
}
\description{
Performs a significantly more efficient surrogate variable analysis for EWAS.
}
\examples{
## Methylation M values (CpG by Sample)
Y <- matrix(rnorm(20*1000), 1000, 20)
df <- data.frame(pred=gl(2, 10))

## Determine the number of SVs
Y.r <- t(resid(lm(t(Y) ~ pred, data=df)))
## Add one to compensate potential loss of 1 degree of freedom
##  in confounded scenarios
n.sv <- EstDimRMT(Y.r, FALSE)$dim + 1
mod <- model.matrix( ~ pred, df)
sv.obj <- smartsva(Y, mod, mod0=NULL, n.sv=n.sv)

}

