% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_similarity.R
\name{experiment_similarity}
\alias{experiment_similarity}
\title{Get cosine similarity for a query dataset against the skeletalvis database}
\usage{
experiment_similarity(skeletalvis, dataset, add_meta_data = TRUE)
}
\arguments{
\item{skeletalvis}{The path to the SkeletalVis data folder.}

\item{dataset}{A dataframe with human gene symbols and log2 fold changes.}

\item{add_meta_data}{Add metadata such as species, tissue, description of overall experiment and specific comparison}
}
\value{
A data frame containing cosine similarity values, IDs, and z-scores.
}
\description{
Computes the cosine similarity of the log2 fold changes of a given query dataset
against the SkeletalVis fold changes, returning a data frame of experiment similarities.
}
\examples{
skeletalvis <- load_skeletalvis(demo=TRUE)

# Create a query dataset (this should be a data frame with the first column as gene IDs)
query_dataset <- data.frame(ID = c("SOX9", "ACAN"), fold_change = c(2.5, -1.8))

# Get cosine similarities
similarity_results <- experiment_similarity(
  skeletalvis = skeletalvis,
  dataset = query_dataset,
)

# View results
head(similarity_results)

}
