% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_surveys.R
\name{expand_surveys}
\alias{expand_surveys}
\title{Set up a series of surveys from all combinations of settings supplied}
\usage{
expand_surveys(
  set_den = c(0.5, 1, 2, 5, 10)/1000,
  lengths_cap = c(5, 10, 20, 50, 100, 500, 1000),
  ages_cap = c(2, 5, 10, 20, 50)
)
}
\arguments{
\item{set_den}{A vector of set densities (sets per grid unit squared).}

\item{lengths_cap}{A vector of maximum numbers of lengths measured per set.}

\item{ages_cap}{A vector of maximum numbers of otoliths to collect per length group
per division per year.}
}
\value{
A \code{data.frame} containing all combinations of the supplied vectors, with an added
\code{survey} column identifying each combination.
}
\description{
A convenience function that wraps \code{\link[base:expand.grid]{base::expand.grid()}} to generate all combinations
of survey design parameters and adds a unique survey number to each row.
}
