% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_pop.R
\name{sim_abundance}
\alias{sim_abundance}
\title{Simulate basic population dynamics model}
\usage{
sim_abundance(
  ages = 1:20,
  years = 1:20,
  Z = sim_Z(),
  R = sim_R(),
  N0 = sim_N0(),
  growth = sim_vonB()
)
}
\arguments{
\item{ages}{Ages to include in the simulation.}

\item{years}{Years to include in the simulation.}

\item{Z}{Total mortality function, like \code{\link{sim_Z}}, for generating
mortality matrix.}

\item{R}{Recruitment (i.e. abundance at \code{min(ages)}) function, like
\code{\link{sim_R}}, for generating recruitment vector.}

\item{N0}{Starting abundance (i.e. abundance at \code{min(years)}) function, like
\code{\link{sim_N0}}, for generating starting abundance vector.}

\item{growth}{Closure, such as \code{\link{sim_vonB}}, for simulating length given age.
The function is used here to generate a abundance-at-age matrix and
it is carried forward for later use in \code{\link{sim_survey}} to simulate
lengths from survey catch at age.}
}
\value{
A \code{list} of length 9:
\itemize{
\item{\code{ages}} - Vector of ages in the simulation
\item{\code{lengths}} - Vector of length groups (depends on growth function)
\item{\code{years}} - Vector of years in the simulation
\item{\code{R} - Vector of recruitment values}
\item{\code{N0} - Vector of starting abundance values}
\item{\code{Z} - Matrix of total mortality values}
\item{\code{N} - Matrix of abundance values}
\item{\code{N_at_length} - Abundance at length matrix}
\item{\code{sim_length} - Function for simulating lengths given ages}
}
}
\description{
Simulate basic population dynamics model
}
\details{
Abundance from is calculated using a standard population dynamics model.
An abundance-at-length matrix is generated using a growth function coded as a closure like
\code{\link{sim_vonB}}. The function is retained for later use in \code{\link{sim_survey}}
to simulate lengths given simulated catch at age in a simulated survey. The ability to simulate
distributions by length is yet to be implemented.
}
\examples{

R_fun <- sim_R(log_mean = log(100000), log_sd = 0.1, random_walk = TRUE, plot = TRUE)
R_fun(years = 1:100)
sim_abundance(R = sim_R(log_mean = log(100000), log_sd = 0.5))
sim_abundance(years = 1:20,
              R = sim_R(log_mean = log(c(rep(100000, 10), rep(10000, 10))), plot = TRUE))

Z_fun <- sim_Z(log_mean = log(0.5), log_sd = 0.1, phi_age = 0.9, phi_year = 0.9, plot = TRUE)
Z_fun(years = 1:100, ages = 1:20)
sim_abundance(Z = sim_Z(log_mean = log(0.5), log_sd = 0.1, plot = TRUE))
Za_dev <- c(-0.2, -0.1, 0, 0.1, 0.2, 0.3, 0.3, 0.2, 0.1, 0)
Zy_dev <- c(-0.2, -0.2, -0.2, -0.2, -0.2, 2, 2, 2, 2, 0.2, 0.2, 0.2, 0.2, 0.2, 0, 0, 0, 0, 0, 0)
Z_mat <- outer(Za_dev, Zy_dev, "+") + 0.5
sim_abundance(ages = 1:10, years = 1:20,
              Z = sim_Z(log_mean = log(Z_mat), plot = TRUE))
sim_abundance(ages = 1:10, years = 1:20,
              Z = sim_Z(log_mean = log(Z_mat), log_sd = 0, phi_age = 0, phi_year = 0, plot = TRUE))

N0_fun <- sim_N0(N0 = "exp", plot = TRUE)
N0_fun(R0 = 1000, Z0 = rep(0.5, 20), ages = 1:20)
sim_abundance(N0 = sim_N0(N0 = "exp", plot = TRUE))

growth_fun <- sim_vonB(Linf = 100, L0 = 5, K = 0.2, log_sd = 0.05, length_group = 1, plot = TRUE)
growth_fun(age = rep(1:15, each = 100))
growth_fun(age = 1:15, length_age_key = TRUE)
sim_abundance(growth = sim_vonB(plot = TRUE))

sim <- sim_abundance()
plot_trend(sim)
plot_surface(sim, mat = "N")
plot_surface(sim, mat = "Z")
plot_surface(sim, mat = "N_at_length", xlab = "Length", zlab = "N")

}
