% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{random_network}
\alias{random_network}
\title{Create a network object.}
\usage{
random_network(p, n_modules = NULL, consistent_connections = FALSE,
  ...)
}
\arguments{
\item{p}{The number of nodes in the network; 'p' is required to be 
between 10 and 20000.}

\item{n_modules}{The number of modules to include in the network. If NULL,
then modules are created until all nodes in the network have positive degree.}

\item{consistent_connections}{If TRUE, then each module is modified so that,
if two genes are connected in one module, then they are connected in 
every module.}

\item{...}{Additional arguments passed to 'create_modules_for_network()',
which uses 'sample_link_nodes_fn()', 'sample_module_nodes_fn()', and
'random_module()'.}
}
\value{
An unweighted network object.
}
\description{
Creates an unweighted 'network' object containing randomly generated 
modules.
}
\examples{
# Create a random network of 10 nodes
nw <- random_network(10)
nw
# Add a random weight to each connection.
nw <- gen_partial_correlations(nw)
# Plot the network
plot(nw)
}
