# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' C++ implementation to obtain connected components in a graph.
#' 
#' @param adj An adjacency matrix.
#' @return Returns a matrix with 2 columns containing the indicies in the
#' lower-triangle of the matrix that are nonzero.
#' @export
components_in_adjacency <- function(adj) {
    .Call('_SeqNet_components_in_adjacency', PACKAGE = 'SeqNet', adj)
}

#' C++ implementation of empirical CDF
#' 
#' Constructs the empirical CDF, F, for a set of observations, x, and 
#' returns F(x).
#' @param x The observation to construct the empirical CDF from.
#' @return Returns the values for F(x).
#' @export
ecdf_cpp <- function(x) {
    .Call('_SeqNet_ecdf_cpp', PACKAGE = 'SeqNet', x)
}

#' C++ implementation for obtaining an edge list from adjacency matrix
#' 
#' @param adj An adjacency matrix.
#' @return Returns a matrix with 2 columns containing the indicies in the
#' lower-triangle of the matrix that are nonzero.
#' @export
edges_from_adjacency_cpp <- function(adj) {
    .Call('_SeqNet_edges_from_adjacency_cpp', PACKAGE = 'SeqNet', adj)
}

#' C++ implementation to check if a matrix is an adjacency matrix
#' 
#' @param m A matrix to check.
#' @return Returns TRUE if the matrix is an adjacency matrix and FALSE 
#' otherwise.
#' @export
is_adjacency_cpp <- function(m) {
    .Call('_SeqNet_is_adjacency_cpp', PACKAGE = 'SeqNet', m)
}

#' C++ implementation to check if a matrix is symmetric
#' 
#' @param m A matrix to check.
#' @param tol A Numeric scalar >= 0. Differences smaller than tol are ignored.
#' @return Returns TRUE if the matrix is symmetric and FALSE otherwise.
#' @export
is_symmetric_cpp <- function(m, tol = 1e-12) {
    .Call('_SeqNet_is_symmetric_cpp', PACKAGE = 'SeqNet', m, tol)
}

#' C++ implementation for creating a ring lattice
#' 
#' @param p The number of nodes in the lattice.
#' @param neig_size The neighborhood side within which nodes are connected.
#' @return Returns the adjacency matrix for the ring lattice.
#' @export
ring_lattice_cpp <- function(p, neig_size) {
    .Call('_SeqNet_ring_lattice_cpp', PACKAGE = 'SeqNet', p, neig_size)
}

