% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bad.response.R
\name{bad.response}
\alias{bad.response}
\title{Bad Responses to NA}
\usage{
bad.response(word, ...)
}
\arguments{
\item{word}{Character.
A word to be tested for whether it is bad}

\item{...}{Vector.
Additional responses to be considered bad}
}
\value{
If response is bad, then returns \code{NA}.
If response is valid, then returns the response
}
\description{
A wrapper function to determine whether responses are good or bad.
Bad responses are replaced with missing (\code{NA}). Good responses are returned.
}
\examples{
# Bad response
bad.response(word = " ")

# Good response
bad.response(word = "hello")

# Make a good response bad
bad.response(word = "hello","hello")

# Add additional bad responses
bad.response(word = "hello", c("hello","world"))

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
