% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooks.distance.R
\name{cooks.distance.SSN2}
\alias{cooks.distance.SSN2}
\alias{cooks.distance.ssn_lm}
\alias{cooks.distance.ssn_glm}
\title{Compute Cook's distance}
\usage{
\method{cooks.distance}{ssn_lm}(model, ...)

\method{cooks.distance}{ssn_glm}(model, ...)
}
\arguments{
\item{model}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A vector of Cook's distance values for each observation from the
fitted model object.
}
\description{
Compute the Cook's distance for each observation from a fitted
model object.
}
\details{
Cook's distance measures the influence of an observation on a fitted
model object. If an observation is influential, its omission from the data
noticeably impacts parameter estimates. The larger the Cook's distance, the
larger the influence.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
cooks.distance(ssn_mod)
}
\seealso{
\code{\link[=augment.SSN2]{augment.SSN2()}} \code{\link[=hatvalues.SSN2]{hatvalues.SSN2()}} \code{\link[=influence.SSN2]{influence.SSN2()}} \code{\link[=residuals.SSN2]{residuals.SSN2()}}
}
