% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_fields.R
\name{check_datatype}
\alias{check_datatype}
\title{Validate SHARK system fields in a data frame}
\usage{
check_datatype(data, level = "error")
}
\arguments{
\item{data}{A \code{data.frame} or \code{tibble} containing SHARK data to validate.}

\item{level}{Character. The level of validation:
\itemize{
\item \code{"error"} (default) — checks only required fields.
\item \code{"warning"} — checks both required and recommended fields.
}}
}
\value{
A \code{tibble} summarizing missing or empty fields, with columns:
\itemize{
\item \code{level}: \code{"error"} or \code{"warning"}.
\item \code{field}: Name of the missing or empty field.
\item \code{row}: Row number where the value is missing (NA) or \code{NA} if the whole column is missing.
\item \code{message}: Description of the issue.
}
}
\description{
This function checks whether the required and recommended global and
datatype-specific SHARK system fields are present in a data frame.
}
\details{
\itemize{
\item \strong{Required fields}: Missing or empty required fields are reported as \strong{errors}.
\item \strong{Recommended fields}: Missing or empty recommended fields are reported as \strong{warnings},
but only if \code{level = "warning"} is specified.
}
}
\examples{
# Example with required fields missing
df <- data.frame(
  visit_year = 2024,
  station_name = NA
)
check_datatype(df, level = "error")

# Example checking recommended fields as warnings
check_datatype(df, level = "warning")

}
