% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maximin.R
\name{maximin.crit}
\alias{maximin.crit}
\title{Maximin criterion}
\usage{
maximin.crit(design, r = 2 * ncol(design), surrogate = FALSE)
}
\arguments{
\item{design}{the design matrix.}

\item{r}{the power used in the reciprocal distance objective function. The default value is set as twice the dimension of the design.}

\item{surrogate}{whether to return the surrogate average reciprocal distance objective function or the maximin distance. If setting surrogate=TRUE, then the average reciprocal distance is returned.}
}
\value{
the maximin distance or reciprocal distance of the design.
}
\description{
This function calculates the maximin distance or the average reciprocal distance of a design.
}
\details{
\code{maximin.crit} calculates the maximin distance or the average reciprocal distance of a design. The maximin distance for a design \eqn{D=[\bm x_1, \dots, \bm x_n]^T} is defined as \eqn{\phi_{Mm} = \min_{i\neq j} \|\bm x_i- \bm x_j\|_2}. In optimization, the average reciprocal distance is usually used (Morris and Mitchell, 1995): \deqn{\phi_{\text{rec}} = \left(\frac{2}{n(n-1)} \sum_{i\neq j}\frac{1}{\|\bm{x}_i-\bm{x}_j\|_2^r}\right)^{1/r}.} The \eqn{r} is a power parameter and when it is large enough, the reciprocal distance is similar to the exact maximin distance.
}
\examples{
n = 20
p = 3
D = randomLHD(n, p)
maximin.crit(D)

}
\references{
Morris, M. D. and Mitchell, T. J. (1995), “Exploratory designs for computational experiments,” Journal of statistical planning and inference, 43, 381–402.
}
