% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.SparseHist.R
\name{SparseHist}
\alias{SparseHist}
\title{SparseHist}
\usage{
SparseHist(X, bin_width = NULL, bin_origin = NULL)
}
\arguments{
\item{X}{[matrix] Dataset to find the SparseHist}

\item{bin_width}{[vector] Width of a bin for each dimension}

\item{bin_origin}{[vector] Coordinate of the "0" bin}
}
\value{
[SparseHist] SparseHist class
}
\description{
Return the Rcpp Class SparseHistBase initialized
}
\examples{
## Data
X = base::matrix( stats::rnorm( n = 10000 ) , nrow = 5000 , ncol = 2 )
muX = SparseHist(X)

print(muX$p) ## Vector of probabilities
print(muX$c) ## Matrix of coordinates of each bins
print(muX$argwhere(X)) ## Index of bins of dataset X

}
