% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{laplafit}
\alias{laplafit}
\title{Fit a Laplace Distribution via maximum likelihood}
\usage{
laplafit(data, verb = 0L, interv_step = 10L, provided_m_ = NULL)
}
\arguments{
\item{data}{(NumericVector) - the sample used to fit the distribution.}

\item{verb}{(int) - the level of verbosity. Select one of:
\itemize{
\item 0  just the final result
\item 1  details of optim. routine
}}

\item{interv_step}{int - the number of intervals to be explored after
the last minimum was found in the interval optimization. Default is 10.}

\item{provided_m_}{NumericVector - if NULL, the m parameter is estimated
by the routine. If numeric, the estimation fixes m to the given value.}
}
\value{
a list containing the following items:
\itemize{
\item "dt" - dataset containing parameters estimations and standard deviations.
\item "log-likelihood" - negative log-likelihood value.
\item "matrix" - the covariance matrix for the parameters.
}
}
\description{
\code{laplafit} returns the parameters, standard errors. negative
log-likelihood and covariance matrix of the Laplace Distribution for a
sample. See details below.
}
\details{
The Laplace distribution is a distribution controlled
by two parameters, with formula:
\deqn{f(x;a,m) = \frac{1}{2a} e^{- \left| \frac{x-m}{a} \right| }}
where \eqn{a} is a scale parameter, and \eqn{m} is a location parameter.
The estimations are produced by maximum likelihood, where analytical
formulas are available. Details on the method can be found on
the package vignette.
}
\examples{
sample_subbo <- rpower(1000, 1, 1)
laplafit(sample_subbo)
}
