% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.get.activities.R
\name{users.get.activities}
\alias{users.get.activities}
\title{List and filter activities assigned to a specific user}
\usage{
users.get.activities(id, due_date = NULL, type = NULL, start = NULL,
  limit = NULL, done = NULL, api_token = NULL,
  company_domain = "api")
}
\arguments{
\item{id}{ID of the user}

\item{due_date}{Either a due date in YYYY-MM-DD format, or one of the following: all, overdue, today, tomorrow, this_week, next_week}

\item{type}{Filter activities based on ActivityType's key_string (examples: call, meeting)}

\item{start}{Pagination start}

\item{limit}{Items shown per page}

\item{done}{Whether to fetch done (1) or undone (0) activities. If omitted from request, both undone and done activities are fetched. This field has the following domains: (0; 1)}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to List and filter activities assigned to a specific user from pipedrive.
}
\examples{
\donttest{
users.get.activities(id='e.g.',api_token='token',company_domain='exp')
}
}
