% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/productfields.update.R
\name{productfields.update}
\alias{productfields.update}
\title{Update a product field}
\usage{
productfields.update(id, name, options = NULL, api_token = NULL,
  company_domain = "api", return_type = c("complete", "boolean"))
}
\arguments{
\item{id}{ID of the field to update.}

\item{name}{Name of the field}

\item{options}{When field_type is either set or enum, possible options must be supplied as a JSON-encoded sequential array of objects. All active items must be supplied and already existing items must have their ID supplied. New items only require a label. Example: [{id:123,label:Existing Item},{label:New Item}] this field must be a JSON.}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}

\item{return_type}{the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)}
}
\value{
customizable return, the default is an object List
}
\description{
Function to Update a product field on pipedrive.
}
\examples{
\donttest{
productfields.update(id='e.g.',name='e.g.',api_token='token',company_domain='exp')
}
}
