% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparrowDfuncObserver.R
\docType{data}
\name{sparrowDfuncObserver}
\alias{sparrowDfuncObserver}
\title{Brewer's Sparrow detection function}
\format{
An estimated distance function object with 
class 'dfunc'. See 'Value' section of 
\code{\link{dfuncEstim}} for 
description of components.
}
\description{
Pre-estimated Brewer's sparrow detection function that 
included and 'observer' effect.  Included to speed up 
example execution times. See 'Examples'.
}
\examples{
\dontrun{
# the following code was used to generate 'sparrowDfuncObserver'
data(sparrowDf)
sparrowDfuncObserver <- sparrowDf |> 
            dfuncEstim(formula = dist ~ observer
                     , likelihood = "hazrate")
}


}
\seealso{
\code{\link{sparrowSiteData}} and 
\code{\link{sparrowDetectionData}} for description of the data
}
