% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_SAMMC.R
\name{do.sammc}
\alias{do.sammc}
\title{Semi-Supervised Adaptive Maximum Margin Criterion}
\usage{
do.sammc(X, label, ndim = 2, type = c("proportion", 0.1),
  preprocess = c("center", "decorrelate", "whiten"), a = 1, b = 1,
  lambda = 1, beta = 1)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center" and other options of "decorrelate" and "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}

\item{a}{tuning parameter for between-class weight in \eqn{[0,\infty)}.}

\item{b}{tuning parameter for within-class weight in \eqn{[0,\infty)}.}

\item{lambda}{balance parameter for between-class and within-class scatter matrices in \eqn{(0,\infty)}.}

\item{beta}{balance parameter for within-class scatter of the labeled data and consistency of the whole data in \eqn{(0,\infty)}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Semi-Supervised Adaptive Maximum Margin Criterion (SAMMC) is a semi-supervised variant of
AMMC by making use of both labeled and unlabeled data.
}
\examples{
\dontrun{
## generate data of 3 types with clear difference
dt1  = aux.gensamples(n=33)-50
dt2  = aux.gensamples(n=33)
dt3  = aux.gensamples(n=33)+50

## merge the data and create a label correspondingly
X      = rbind(dt1,dt2,dt3)
label  = c(rep(1,33), rep(2,33), rep(3,33))

## copy a label and let 20\% of elements be missing
nlabel = length(label)
nmissing = round(nlabel*0.20)
label_missing = label
label_missing[sample(1:nlabel, nmissing)]=NA

## try different balancing
out1 = do.sammc(X, label_missing, beta=0.1)
out2 = do.sammc(X, label_missing, beta=1)
out3 = do.sammc(X, label_missing, beta=10)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="SAMMC::beta=0.1")
plot(out2$Y[,1], out2$Y[,2], main="SAMMC::beta=1")
plot(out3$Y[,1], out3$Y[,2], main="SAMMC::beta=10")
}

}
\references{
\insertRef{lu_adaptive_2011}{Rdimtools}
}
\seealso{
\code{\link{do.mmc}}, \code{\link{do.ammc}}
}
\author{
Kisung You
}
