\name{assignCluster}
\alias{assignCluster}

\title{Append a Cluster Membership Variable to a Dataframe}
\description{
  Correctly creates a cluster membership variable that can be attached to a
  dataframe when only a subset of the observations in that dataframe were used
  to create the clustering solution. NAs are assigned to the observations of the
  original dataframe not used in creating the clustering solution.
}

\usage{
assignCluster(clusterData, origData, clusterVec)
}

\arguments{
  \item{clusterData}{The data matrix used in the clustering solution.
  The data matrix may have have only a subset of the observations contained in
  the original dataframe.}
  \item{origData}{The original dataframe from which the data used in the
  clustering solution were taken.}
  \item{clusterVec}{An integer variable containing the cluster membership 
  assignments for the observations used in creating the clustering solution.
  This vector can be created using \code{cutree} for clustering solutions
  generated by \code{hclust} or the \code{cluster} component of a list object
  created by \code{kmeans} or \code{KMeans}.}
}

\value{
  A factor (with integer labels) that indicate the cluster assignment for each
  observation, with an NA value given to observations not used in the clustering
  solution.
}

\author{Dan Putler}

\seealso{\code{\link[stats]{hclust}}, \code{\link[stats]{cutree}}, \code{\link[stats]{kmeans}}, 
\code{\link{KMeans}}}

\examples{
  data(USArrests)
  USArrkm3 <- KMeans(USArrests[USArrests$UrbanPop<66, ], centers=3)
  assignCluster(USArrests[USArrests$UrbanPop<66, ], USArrests, USArrkm3$cluster)
}
\keyword{misc}

