/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.SimpleBatchFilter;

public class RELAGGS
extends SimpleBatchFilter
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -3333791375278589231L;
    protected int m_MaxCardinality = 20;
    protected Range m_SelectedRange = new Range("first-last");
    protected Hashtable<String, AttributeStats> m_AttStats = new Hashtable();

    public String globalInfo() {
        return "A propositionalization filter inspired by the RELAGGS algorithm.\nIt processes all relational attributes that fall into the user defined range (all others are skipped, i.e., not added to the output). Currently, the filter only processes one level of nesting.\nThe class attribute is not touched.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "M.-A. Krogel and S. Wrobel");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Facets of Aggregation Approaches to Propositionalization");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Work-in-Progress Track at the Thirteenth International Conference on Inductive Logic Programming (ILP)");
        technicalInformation.setValue(TechnicalInformation.Field.EDITOR, "T. Horvath and A. Yamamoto");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2003");
        technicalInformation.setValue(TechnicalInformation.Field.PDF, "http://kd.cs.uni-magdeburg.de/~krogel/papers/aggs.pdf");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tSpecify list of string attributes to convert to words.\n\t(default: select all relational attributes)", "R", 1, "-R <index1,index2-index4,...>"));
        vector.addElement(new Option("\tInverts the matching sense of the selection.", "V", 0, "-V"));
        vector.addElement(new Option("\tMax. cardinality of nominal attributes. If a nominal attribute\n\thas more values than this upper limit, then it will be skipped.\n\t(default: 20)", "C", 1, "-C <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setSelectedRange(string);
        } else {
            this.setSelectedRange("first-last");
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setMaxCardinality(Integer.parseInt(string));
        } else {
            this.setMaxCardinality(20);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-R");
        vector.add(this.getSelectedRange().getRanges());
        if (this.getInvertSelection()) {
            vector.add("-V");
        }
        vector.add("-C");
        vector.add("" + this.getMaxCardinality());
        return vector.toArray(new String[vector.size()]);
    }

    public String maxCardinalityTipText() {
        return "The maximum number of values a nominal attribute can have before it's skipped.";
    }

    public void setMaxCardinality(int n) {
        this.m_MaxCardinality = n;
    }

    public int getMaxCardinality() {
        return this.m_MaxCardinality;
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on; this is a comma separated list of attribute indices, with \"first\" and \"last\" valid values; Specify an inclusive range with \"-\"; eg: \"first-3,5,6-10,last\".";
    }

    public void setSelectedRange(String string) {
        this.m_SelectedRange = new Range(string);
    }

    public Range getSelectedRange() {
        return this.m_SelectedRange;
    }

    public String invertSelectionTipText() {
        return "Set attribute selection mode. If false, only selected attributes in the range will be worked on; if true, only non-selected attributes will be processed.";
    }

    public void setInvertSelection(boolean bl) {
        this.m_SelectedRange.setInvert(bl);
    }

    public boolean getInvertSelection() {
        return this.m_SelectedRange.getInvert();
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    protected Instances determineOutputFormat(Instances instances) throws Exception {
        this.m_SelectedRange.setUpper(instances.numAttributes() - 1);
        FastVector fastVector = new FastVector();
        int n = -1;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (i == instances.classIndex()) {
                n = fastVector.size();
                fastVector.addElement(instances.attribute(i).copy());
                continue;
            }
            if (!instances.attribute(i).isRelationValued()) {
                fastVector.addElement(instances.attribute(i).copy());
                continue;
            }
            if (!this.m_SelectedRange.isInRange(i)) {
                if (!this.getDebug()) continue;
                System.out.println("Attribute " + (i + 1) + " (" + instances.attribute(i).name() + ") skipped.");
                continue;
            }
            String string = instances.attribute(i).name() + "_";
            Instances instances2 = instances.attribute(i).relation();
            for (int j = 0; j < instances2.numAttributes(); ++j) {
                Attribute attribute = instances2.attribute(j);
                if (attribute.isNumeric()) {
                    fastVector.addElement(new Attribute(string + attribute.name() + "_MIN"));
                    fastVector.addElement(new Attribute(string + attribute.name() + "_MAX"));
                    fastVector.addElement(new Attribute(string + attribute.name() + "_AVG"));
                    fastVector.addElement(new Attribute(string + attribute.name() + "_STDEV"));
                    fastVector.addElement(new Attribute(string + attribute.name() + "_SUM"));
                    continue;
                }
                if (attribute.isNominal()) {
                    if (attribute.numValues() <= this.m_MaxCardinality) {
                        for (int k = 0; k < attribute.numValues(); ++k) {
                            fastVector.addElement(new Attribute(string + attribute.name() + "_" + attribute.value(k) + "_CNT"));
                        }
                        continue;
                    }
                    if (!this.getDebug()) continue;
                    System.out.println("Attribute " + (i + 1) + "/" + (j + 1) + " (" + instances.attribute(i).name() + "/" + attribute.name() + ") skipped, " + attribute.numValues() + " > " + this.m_MaxCardinality + ".");
                    continue;
                }
                if (!this.getDebug()) continue;
                System.out.println("Attribute " + (i + 1) + "/" + (j + 1) + " (" + instances.attribute(i).name() + "/" + attribute.name() + ") skipped.");
            }
        }
        Instances instances3 = new Instances(instances.relationName(), fastVector, 0);
        instances3.setClassIndex(n);
        this.initOutputLocators(instances3, new int[0]);
        return instances3;
    }

    protected Instances process(Instances instances) throws Exception {
        AttributeStats attributeStats;
        Attribute attribute;
        int n;
        Instances instances2;
        int n2;
        int n3;
        Instances instances3 = this.getOutputFormat();
        this.m_AttStats.clear();
        for (n3 = 0; n3 < instances.numAttributes(); ++n3) {
            if (n3 == instances.classIndex() || !instances.attribute(n3).isRelationValued() || !this.m_SelectedRange.isInRange(n3)) continue;
            for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                instances2 = instances.instance(n2).relationalValue(n3);
                for (n = 0; n < instances2.numAttributes(); ++n) {
                    attribute = instances2.attribute(n);
                    attributeStats = null;
                    if (!attribute.isNumeric() && (!attribute.isNominal() || attribute.numValues() > this.m_MaxCardinality)) continue;
                    attributeStats = instances2.attributeStats(n);
                    this.m_AttStats.put(n2 + "-" + n3 + "-" + n, attributeStats);
                }
            }
        }
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            Instance instance = instances.instance(n2);
            Instance instance2 = new Instance(instances3.numAttributes());
            instance2.setWeight(instance.weight());
            int n4 = 0;
            for (n3 = 0; n3 < instances.numAttributes(); ++n3) {
                if (!instances.attribute(n3).isRelationValued()) {
                    instance2.setValue(n4, instance.value(n3));
                    ++n4;
                    continue;
                }
                if (!this.m_SelectedRange.isInRange(n3)) continue;
                instances2 = instance.relationalValue(n3);
                for (n = 0; n < instances2.numAttributes(); ++n) {
                    attribute = instances2.attribute(n);
                    attributeStats = this.m_AttStats.get(n2 + "-" + n3 + "-" + n);
                    if (attribute.isNumeric()) {
                        instance2.setValue(n4, attributeStats.numericStats.min);
                        instance2.setValue(++n4, attributeStats.numericStats.max);
                        instance2.setValue(++n4, attributeStats.numericStats.mean);
                        instance2.setValue(++n4, attributeStats.numericStats.stdDev);
                        instance2.setValue(++n4, attributeStats.numericStats.sum);
                        ++n4;
                        continue;
                    }
                    if (!attribute.isNominal() || attribute.numValues() > this.m_MaxCardinality) continue;
                    for (int i = 0; i < attribute.numValues(); ++i) {
                        instance2.setValue(n4, (double)attributeStats.nominalCounts[i]);
                        ++n4;
                    }
                }
            }
            instances3.add(instance2);
        }
        return instances3;
    }

    public static void main(String[] stringArray) {
        RELAGGS.runFilter(new RELAGGS(), stringArray);
    }
}

