/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import weka.gui.CustomPanelSupplier;
import weka.gui.PropertyDialog;

public class PropertyPanel
extends JPanel {
    private PropertyEditor m_Editor;
    private PropertyDialog m_PD;
    private boolean m_HasCustomPanel = false;

    public PropertyPanel(PropertyEditor propertyEditor) {
        this(propertyEditor, false);
    }

    public PropertyPanel(PropertyEditor propertyEditor, boolean bl) {
        this.m_Editor = propertyEditor;
        if (!bl && this.m_Editor instanceof CustomPanelSupplier) {
            this.setLayout(new BorderLayout());
            this.add((Component)((CustomPanelSupplier)((Object)this.m_Editor)).getCustomPanel(), "Center");
            this.m_HasCustomPanel = true;
        } else {
            this.createDefaultPanel();
        }
    }

    protected void createDefaultPanel() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setToolTipText("Click to edit properties for this object");
        this.setOpaque(true);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PropertyPanel.this.showPropertyDialog();
            }
        });
        Dimension dimension = this.getPreferredSize();
        dimension.height = this.getFontMetrics(this.getFont()).getHeight() * 5 / 4;
        dimension.width = dimension.height * 5;
        this.setPreferredSize(dimension);
        this.m_Editor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PropertyPanel.this.repaint();
            }
        });
    }

    public void showPropertyDialog() {
        if (this.m_Editor.getValue() != null) {
            if (this.m_PD == null) {
                int n = this.getLocationOnScreen().x;
                int n2 = this.getLocationOnScreen().y;
                this.m_PD = new PropertyDialog(this.m_Editor, n, n2);
            } else {
                this.m_PD.setVisible(true);
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.m_PD != null) {
            this.m_PD.dispose();
            this.m_PD = null;
        }
    }

    public void paintComponent(Graphics graphics) {
        if (!this.m_HasCustomPanel) {
            Insets insets = this.getInsets();
            Rectangle rectangle = new Rectangle(insets.left, insets.top, this.getSize().width - insets.left - insets.right - 1, this.getSize().height - insets.top - insets.bottom - 1);
            graphics.clearRect(insets.left, insets.top, this.getSize().width - insets.right - insets.left, this.getSize().height - insets.bottom - insets.top);
            this.m_Editor.paintValue(graphics, rectangle);
        }
    }
}

