/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.SplitCriterion;

public abstract class EntropyBasedSplitCrit
extends SplitCriterion {
    protected static double log2 = Math.log(2.0);

    public final double logFunc(double d) {
        if (d < 1.0E-6) {
            return 0.0;
        }
        return d * Math.log(d) / log2;
    }

    public final double oldEnt(Distribution distribution) {
        double d = 0.0;
        for (int i = 0; i < distribution.numClasses(); ++i) {
            d += this.logFunc(distribution.perClass(i));
        }
        return this.logFunc(distribution.total()) - d;
    }

    public final double newEnt(Distribution distribution) {
        double d = 0.0;
        for (int i = 0; i < distribution.numBags(); ++i) {
            for (int j = 0; j < distribution.numClasses(); ++j) {
                d += this.logFunc(distribution.perClassPerBag(i, j));
            }
            d -= this.logFunc(distribution.perBag(i));
        }
        return -d;
    }

    public final double splitEnt(Distribution distribution) {
        double d = 0.0;
        for (int i = 0; i < distribution.numBags(); ++i) {
            d += this.logFunc(distribution.perBag(i));
        }
        return this.logFunc(distribution.total()) - d;
    }
}

