% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.input.R
\name{validate.annot}
\alias{validate.annot}
\title{Validate Annotation Table}
\usage{
validate.annot(
  data,
  annot,
  annot.flags,
  sample.id,
  fill = "CPM",
  baseline.flag = NULL,
  baseline.val = NULL
)
}
\arguments{
\item{data}{The input count data.}

\item{annot}{The annotation dataframe.}

\item{annot.flags}{The vector of annotation flags passed by the user.}

\item{sample.id}{Sample id label to check if in annot.}

\item{fill}{The fill value indicated by the user,"count" or "CPM".}

\item{baseline.flag}{The baseline.flag passed by the user.}

\item{baseline.val}{The baseline value passed by the user.}
}
\description{
Ensure that an annotation has all of the required columns.
}
\details{
The function will check the following:
\itemize{
\item The \code{annot.flags} values are columns in \code{annot}
\item If \code{fill} = "cfb": validate the \code{baseline.flag} and
\code{baseline.val} parameters.
\item \code{sample.id} is a column in \code{annot}.
}
}
\references{
Xingpeng Li, Tatiana Gelaf Romer & Siddhartha Pachhai RVA - RNAseq Visualization Automation tool.
}
