% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_api_pkgzip.R
\name{pkgzip_build_ext_packages}
\alias{pkgzip_build_ext_packages}
\title{Builds PKGZIP out of passed external packages.}
\usage{
pkgzip_build_ext_packages(pkgs, prj = NULL, pkg_type = .Platform$pkgType,
  path = getwd(), with_deps = FALSE, filter_repo = NULL)
}
\arguments{
\item{pkgs}{vector of names of external packages which should be included in
PKGZIP. (type: character)}

\item{prj}{project object to use. If not passed will init project from
working directory. (type: rsuite_project, default: NULL)}

\item{pkg_type}{type of packages to build (type: character, default: platform default)}

\item{path}{folder path to put output zip into. The folder must exist.
(type: character(1), default: getwd())}

\item{with_deps}{If TRUE will include dependencies pkgs dependencies into final zip.
(type: logical, default: FALSE)}

\item{filter_repo}{repository address to not include dependencies available in.
If NULL will not filter dependencies. Will be omitted if with_deps is FALSE.
(type: character(1), default: NULL)}
}
\value{
created pkgzip file path (invisible).
}
\description{
Builds PKGZIP out of passed external packages.
}
\details{
It uses the project to detect repositories to look for packages in.

Logs all messages onto rsuite logger. Use  \code{logging::setLevel} to control logs
verbosity.
}
\examples{
\donttest{
  # create exemplary project base folder
  prj_base <- tempfile("example_")
  dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

  # start project
  prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

  # build PKGZIP with logging package
  pkgzip_fpath <- pkgzip_build_ext_packages("logging", prj = prj, path = tempdir())

  # list content of pkgzip created
  unzip(pkgzip_fpath, list = TRUE)
}

}
\seealso{
Other in PKGZIP building: \code{\link{pkgzip_build_github_package}},
  \code{\link{pkgzip_build_package_files}},
  \code{\link{pkgzip_build_prj_packages}}
}
