% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{autoCalibrate,RPhosFate-method}
\alias{autoCalibrate,RPhosFate-method}
\alias{autoCalibrate}
\title{One dimensional automatic model calibration}
\usage{
\S4method{autoCalibrate}{RPhosFate}(
  x,
  substance,
  col,
  interval,
  metric,
  tol = min(interval) * 0.1,
  parameter = NULL
)
}
\arguments{
\item{x}{An S4 \code{\linkS4class{RPhosFate}} river catchment object.}

\item{substance}{A character string specifying the substance to calculate.}

\item{col}{A character string specifying the calibration data column with the
respective substance river loads.}

\item{interval}{A numeric vector specifying the end-points of the interval to
be searched.}

\item{metric}{A character string specifying the metric to optimise. See
\code{\link{calibrationQuality}} for available metrics.}

\item{tol}{A numeric scalar specifying the desired accuracy of the parameter
used for optimisation (not the metric).}

\item{parameter}{By default, SS are calibrated utilising the overland
deposition rate and all other substances are calibrated utilising their
respective enrichment ratio. This argument can be used to specify a
dedicated parameter utilised for calibration via a character string:
\code{"ns_dep_ovl"} for overland or \code{"ns_dep_cha"} for channel deposition rate.}
}
\value{
An S4 \code{\linkS4class{RPhosFate}} river catchment object and side effects in
the form of raster files.
}
\description{
Automatically calibrates the model with the help of a combination of golden
section search and successive parabolic interpolation.
}
\examples{
\donttest{
# temporary demonstration project copy
cv_dir <- demoProject()
# load temporary demonstration project
x <- RPhosFate(
  cv_dir = cv_dir,
  ls_ini = TRUE
)
# presupposed method calls
x <- firstRun(x, "SS")
x <- snapGauges(x)

x <- autoCalibrate(
  x,
  "SS",
  col = "SS_load",
  interval = c(10e-4, 20e-4),
  metric = "NSE"
)}

}
\seealso{
\code{\link{snapGauges}}, \code{\link{optimize}}
}
