/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import it.bancaditalia.oss.sdmx.util.Utils;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class EnumedListTableModel<T>
extends AbstractTableModel {
    private static final long serialVersionUID = 3265022631397431923L;
    private final String[] columnIdentifiers;
    private Object[][] items = new Object[0][];

    public EnumedListTableModel(String string, String string2) {
        this.columnIdentifiers = new String[]{"", string, string2};
    }

    public void clear() {
        this.items = new Object[0][];
        this.fireTableDataChanged();
    }

    public void setItems(Map<String, String> map) {
        Object[][] objectArrayArray = new Object[map.size()][];
        int n = 0;
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                objectArrayArray[n] = new Object[]{n++, entry.getKey(), entry.getValue()};
            }
        }
        this.items = objectArrayArray;
        this.fireTableDataChanged();
    }

    public void setItems(List<T> list, Utils.Function<? super T, String[]> function) {
        Object[][] objectArrayArray = new Object[list.size()][];
        int n = 0;
        if (list != null) {
            for (T t : list) {
                Object[] objectArray = new Object[]{n, null, null};
                System.arraycopy(function.apply(t), 0, objectArray, 1, 2);
                objectArrayArray[n++] = objectArray;
            }
        }
        this.items = objectArrayArray;
        this.fireTableDataChanged();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return n == 0 ? Integer.class : String.class;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnIdentifiers[n];
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.items.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.items[n][n2];
    }
}

