% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc2dd.R
\name{doc2dd}
\alias{doc2dd}
\title{Doc table to data dictionary - EARLY, DOCS MISSING}
\usage{
doc2dd(
  data,
  instrument.name,
  col.variables = 1,
  list.datetime.format = list(date_dmy = "_dat[eo]$", time_hh_mm_ss = "_ti[md]e?$"),
  col.description = NULL,
  col.condition = NULL,
  col.subheader = NULL,
  subheader.tag = "h2",
  condition.minor.sep = ",",
  condition.major.sep = ";",
  col.calculation = NULL,
  col.choices = NULL,
  choices.char.sep = "/",
  missing.default = NA
)
}
\arguments{
\item{data}{tibble or data.frame with all variable names in one column}

\item{instrument.name}{character vector length one. Instrument name.}

\item{col.variables}{variable names column (default = 1), allows dplyr
subsetting}

\item{list.datetime.format}{formatting for date/time detection.
See `case_match_regex_list()`}

\item{col.description}{descriptions column, allows dplyr
subsetting. If empty, variable names will be used.}

\item{col.condition}{conditions for branching column, allows dplyr
subsetting. See `char2cond()`.}

\item{col.subheader}{sub-header column, allows dplyr subsetting.
See `format_subheader()`.}

\item{subheader.tag}{formatting tag. Default is "h2"}

\item{condition.minor.sep}{condition split minor. See `char2cond()`.
Default is ",".}

\item{condition.major.sep}{condition split major. See `char2cond()`.
Default is ";".}

\item{col.calculation}{calculations column. Has to be written exact.
Character vector.}

\item{col.choices}{choices column. See `char2choice()`.}

\item{choices.char.sep}{choices split. See `char2choice()`. Default is "/".}

\item{missing.default}{value for missing fields. Default is NA.}
}
\value{
tibble or data.frame (same as data)
}
\description{
Works well with `project.aid::docx2list()`.
Allows defining a database in a text document (see provided template) for
an easier to use data base creation. This approach allows easier
collaboration when defining the database. The generic case is a data frame
with variable names as values in a column. This is a format like the REDCap
data dictionary, but gives a few options for formatting.
}
\examples{
# data <- dd_inst
# data |> doc2dd(instrument.name = "evt",
# col.description = 3,
# col.condition = 4,
# col.subheader = 2,
# col.calculation = 5,
# col.choices = 6)
}
