% Generated by roxygen2 (4.0.1): do not edit by hand
\name{loadEnsemble}
\alias{loadEnsemble}
\title{Load a unique CMIP5 ensemble}
\usage{
loadEnsemble(variable, model, experiment, ensemble, domain, path = ".",
  recursive = TRUE, verbose = FALSE, force.ncdf = FALSE,
  yearRange = NULL)
}
\arguments{
\item{variable}{CMIP5 variable to load (required)}

\item{model}{CMIP5 model to load (required)}

\item{experiment}{CMIP5 experiment to load (required)}

\item{ensemble}{CMIP5 ensemble to load (required)}

\item{domain}{optinal CMIP5 domain to load (required)}

\item{path}{optional root of directory tree}

\item{recursive}{logical. Recurse into directories?}

\item{verbose}{logical. Print info as we go?}

\item{force.ncdf}{Force use of the less-desirable ncdf package for testing?}

\item{yearRange}{numeric of length 2. If supplied, load only these years of data inclusively between these years.}
}
\value{
A \code{\link{cmip5data}} object.
}
\description{
Loads the data for a particular CMIP5 experiment-variable-model-ensemble
combination (one or more files). Returns NULL and a warning if nothing matches.
}
\details{
This function is the core of RCMIP5's data-loading. It loads all files matching
the experiment, variable, model, ensemble, and domain supplied by the caller.
}
\note{
The \code{yearRange} parameter is intended to help users deal with large
CMIP5 data files on memory-limited machines, e.g. by allowing them to process
smaller chunks of such files.

This is an internal RCMIP5 function and not exported.
}
\keyword{internal}

