% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsa.crosstabs.r
\name{lsa.crosstabs}
\alias{lsa.crosstabs}
\title{Compute crosstabulations and design corrected chi-square statistics}
\usage{
lsa.crosstabs(
  data.file,
  data.object,
  split.vars,
  bckg.row.var,
  bckg.col.var,
  expected.cnts = TRUE,
  row.pcts = FALSE,
  column.pcts = FALSE,
  total.pcts = FALSE,
  weight.var,
  include.missing = FALSE,
  shortcut = FALSE,
  save.output = TRUE,
  output.file,
  open.output = TRUE
)
}
\arguments{
\item{data.file}{A file containing \code{lsa.data} object. Either this or
\code{data.object} shall be specified, but not both. See details.}

\item{data.object}{An object in the memory containing \code{lsa.data}. Either this
or \code{data.file} shall be specified, but not both. See details.}

\item{split.vars}{Categorical variable(s) to split the results by. If no split variables
are provided, the results will be for the overall countries'
populations. If one or more variables are provided, the results will be
split by all but the last variable and the percentages of respondents
will be computed by the unique values of the last splitting variable.}

\item{bckg.row.var}{Name of the categorical background row variable. The results will be
computed by all groups specified by the splitting variables. See details.}

\item{bckg.col.var}{Name of the categorical background column variable. The results will be
computed by all groups specified by the splitting variables. See details.}

\item{expected.cnts}{Logical, shall the expected counts be computed as well? The default
(\code{TRUE}) will compute the expected counts. If \code{FALSE}, only
the observed counts will be included in the output.}

\item{row.pcts}{Logical, shall row percentages be computed? The default (\code{FALSE})
will skip the computation of the row percentages.}

\item{column.pcts}{Logical, shall column percentages be computed? The default (\code{FALSE})
will skip the computation of the column percentages.}

\item{total.pcts}{Logical, shall percentages of total be computed? The default
(\code{FALSE}) will skip the computation of the total percentages.}

\item{weight.var}{The name of the variable containing the weights. If no name of a weight
variable is provided, the function will automatically select the default
weight variable for the provided data, depending on the respondent type.}

\item{include.missing}{Logical, shall the missing values of the splitting variables be included
as categories to split by and all statistics produced for them? The
default (\code{FALSE}) takes all cases on the splitting variables
without missing values before computing any statistics. See details.}

\item{shortcut}{Logical, shall the "shortcut" method for IEA TIMSS, TIMSS Advanced,
TIMSS Numeracy, eTIMSS, PIRLS, ePIRLS, PIRLS Literacy and RLII be
applied? The default (\code{FALSE}) applies the "full" design when
computing the variance components and the standard errors of the
estimates.}

\item{save.output}{Logical, shall the output be saved in MS Excel file (default) or not
(printed to the console or assigned to an object).}

\item{output.file}{If \code{save.output = TRUE} (default), full path to the output file
including the file name. If omitted, a file with a default file name
"Analysis.xlsx" will be written to the working directory
(\code{getwd()}). Ignored if \code{save.output = FALSE}.}

\item{open.output}{Logical, shall the output be open after it has been written? The default
(\code{TRUE}) opens the output in the default spreadsheet program
installed on the computer. Ignored if \code{save.output = FALSE}.}
}
\value{
If \code{save.output = FALSE}, a list containing the estimates and analysis information. If \code{save.output = TRUE} (default), an MS Excel (\code{.xlsx}) file (which can be opened in any spreadsheet program), as specified with the full path in the \code{output.file}. If the argument is missing, an Excel file with the generic file name "Analysis.xlsx" will be saved in the working directory (\code{getwd()}). The workbook contains four spreadsheets. The first one ("Estimates") contains a table with the results by country and the final part of the table contains averaged results from all countries' statistics. The following columns can be found in the table, depending on the specification of the analysis:

\itemize{
\item \verb{<}Country ID\verb{>} - a column containing the names of the countries in the file for which statistics are computed. The exact column header will depend on the country identifier used in the particular study.
\item \verb{<}Split variable 1\verb{>}, \verb{<}Split variable 2\verb{>}... - columns containing the categories by which the statistics were split by. The exact names will depend on the variables in \code{split.vars}.
\item n_Cases - the number of cases in the sample used to compute the statistics for each split combination defined by the \code{split.vars}, if any, and the \code{bckg.row.var}.
\item Sum_\verb{<}Weight variable\verb{>} - the estimated population number of elements per group after applying the weights. The actual name of the weight variable will depend on the weight variable used in the analysis.
\item Sum_\verb{<}Weight variable\verb{>}\verb{_}SE - the standard error of the the estimated population number of elements per group. The actual name of the weight variable will depend on the weight variable used in the analysis.
\item Percentages_\verb{<}Row variable\verb{>} - the percentages of respondents (population estimates) per groups defined by the splitting variables in \code{split.vars}, if any, and the row variable in \code{bckg.row.var}. The percentages will be for the combination of categories in the last splitting variable and the row variable which define the final groups.
\item Percentages_\verb{<}Row variable\verb{>}\verb{_}SE - the standard errors of the percentages from above.
\item Type - the type of computed values depending on the logical values passed to the \code{expected.cnts}, \code{row.pcts}, \code{column.pcts}, and \code{total.pcts} arguments: "Observed count", "Expected count", "Row percent", "Column percent", and "Percent of total".
\item \verb{<}Column variable name Category 1\verb{>}, \verb{<}Column variable name Category 1\verb{>},... - the estimated values for all combinations between the row and column variables passed to \code{bckg.row.var} and \code{bckg.col.var}. There will be one column for each category of the column variable.
\item \verb{<}Column variable name Category 1, 2,... n\verb{>}\verb{_}SE - the standard errors of the estimated values from the above.
\item Total - the grand totals for each of the estimated value types ("Observed count", "Expected count", "Row percent", "Column percent", and "Percent of total") depending on the logical values (\code{TRUE}, \code{FALSE}) passed to the \code{expected.cnts}, \code{row.pcts}, \code{column.pcts}, and \code{total.pcts} arguments.
\item Total\verb{_}SE - the standard errors of the estimated values from the above.
}
The second sheet contains some additional information related to the analysis per country in the following columns:
\itemize{
\item \verb{<}Country ID\verb{>} - a column containing the names of the countries in the file for which statistics are computed. The exact column header will depend on the country identifier used in the particular study.
\item \verb{<}Split variable 1\verb{>}, \verb{<}Split variable 2\verb{>}... - columns containing the categories by which the statistics were split by. The exact names will depend on the variables in \code{split.vars}.
\item Statistics - contains the names of the different statistics types: chi-squares, degrees of freedom (sample and design), and p-values.
\item Value - the estimated values for the statistics from above.
}
The third sheet contains some additional information related to the analysis per country in the following columns:
\itemize{
\item DATA - used \code{data.file} or \code{data.object}.
\item STUDY - which study the data comes from.
\item CYCLE - which cycle of the study the data comes from.
\item WEIGHT - which weight variable was used.
\item DESIGN - which resampling technique was used (JRR or BRR).
\item SHORTCUT - logical, whether the shortcut method was used.
\item NREPS - how many replication weights were used.
\item ANALYSIS_DATE - on which date the analysis was performed.
\item START_TIME - at what time the analysis started.
\item END_TIME - at what time the analysis finished.
\item DURATION - how long the analysis took in hours, minutes, seconds and milliseconds.
}

The fourth sheet contains the call to the function with values for all parameters as it was executed. This is useful if the analysis needs to be replicated later.
}
\description{
\code{lsa.crosstabs} computes two-way tables and estimates the Rao-Scott first- and second-order adjusted chi-square.
}
\details{
The function computes two-way tables between two categorical variables and estimates the Rao-Scott first- and second-order design correction of the chi-square statistics. All statistics are computed within the groups specified by the last splitting variable. If no splitting variables are added, the results will be computed only by country.

Either \code{data.file} or \code{data.object} shall be provided as source of data. If both of them are provided, the function will stop with an error message.

Only two (row and column) categorical variables can be provided. The function always computes the observed counts. If requested, the expected counts, row percentages, column percentages and total percentages can be computed as well.

If \code{include.missing = FALSE} (default), all cases with missing values on the splitting variables will be removed and only cases with valid values will be retained in the statistics. Note that the data from the studies can be exported in two different ways: (1) setting all user-defined missing values to \code{NA}; and (2) importing all user-defined missing values as valid ones and adding their codes in an additional attribute to each variable. If the \code{include.missing} is set to \code{FALSE} (default) and the data used is exported using option (2), the output will remove all values from the variable matching the values in its \code{missings} attribute. Otherwise, it will include them as valid values and compute statistics for them.

The \code{shortcut} argument is valid only for TIMSS, eTIMSS, TIMSS Advanced, TIMSS Numeracy, PIRLS, ePIRLS, PIRLS Literacy and RLII. Previously, in computing the standard errors, these studies were using 75 replicates because one of the schools in the 75 JK zones had its weights doubled and the other one has been taken out. Since TIMSS 2015 and PIRLS 2016 the studies use 150 replicates and in each JK zone once a school has its weights doubled and once taken out, i.e. the computations are done twice for each zone. For more details see Foy & LaRoche (2016) and Foy & LaRoche (2017).

The function also computes chi-square statistics with Rao-Scott first- and second-order design corrections because of the clustering in complex survey designs. For more details, see Rao & Scott (1984, 1987) and Skinner (2019).
}
\examples{
# Compute two-way table between student sex and how much they proud they are proud to go to
# school using PIRLS 2016 student data.
\dontrun{
lsa.crosstabs(data.file = "C:/Data/PIRLS_2016_G8_Student_Miss_to_NA.RData",
bckg.row.var = "ITSEX", bckg.col.var = "ASBG12E")
}

# Same as the above, this time also computing the expected counts, row percentages, column
# percentages, percentages of total.
\dontrun{
lsa.crosstabs(data.file = "C:/Data/PIRLS_2016_G8_Student_Miss_to_NA.RData",
bckg.row.var = "ITSEX", bckg.col.var = "ASBG12E", expected.cnts = TRUE,
row.pcts = TRUE, column.pcts = TRUE, total.pcts = TRUE)
}

}
\references{
LaRoche, S., Joncas, M., & Foy, P. (2016). Sample Design in TIMSS 2015. In M. O. Martin, I. V. S. Mullis, & M. Hooper (Eds.), \emph{Methods and Procedures in TIMSS 2015} (pp. 3.1-3.37). Chestnut Hill, MA: TIMSS & PIRLS International Study Center.
LaRoche, S., Joncas, M., & Foy, P. (2017). Sample Design in PIRLS 2016. In M. O. Martin, I. V. S. Mullis, & M. Hooper (Eds.), \emph{Methods and Procedures in PIRLS 2016} (pp. 3.1-3.34). Chestnut Hill, MA: Lynch School of Education, Boston College.
Rao, J. N. K., & Scott, A. J. (1984). On Chi-Squared Tests for Multiway Contingency Tables with Cell Proportions Estimated from Survey Data. \emph{The Annals of Statistics}, \emph{12}(1). https://doi.org/10.1214/aos/1176346391
Rao, J. N. K., & Scott, A. J. (1987). On Simple Adjustments to Chi-Square Tests with Sample Survey Data. \emph{The Annals of Statistics}, \emph{15}(1), 385-397.
Skinner, C. (2019). Analysis of Categorical Data for Complex Surveys. \emph{International Statistical Review}, \emph{87}(S1), S64-S78. https://doi.org/10.1111/insr.12285
}
\seealso{
\code{\link{lsa.convert.data}}
}
