% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QTE.RD-package.R
\docType{package}
\name{QTE.RD-package}
\alias{QTE.RD}
\alias{QTE.RD-package}
\title{QTE.RD: Quantile Treatment Effects under the Regression Discontinuity Design}
\description{
Provides comprehensive methods for testing, estimating, and conducting uniform inference on quantile treatment effects (QTEs) in sharp regression discontinuity (RD) designs, incorporating covariates and implementing robust bias correction methods of Qu, Yoon, Perron (2024) \doi{10.1162/rest_a_01168}.
}
\details{
The package \code{QTE.RD} includes four main functions:
\itemize{
\item \code{rd.qte} estimates QTEs and provides uniform confidence bands, with or without covariates,
and with or without robust bias correction.
\item \code{rdq.test} conducts tests for three hypotheses, related to the significance of
treatment effects, homogeneous treatment effects, and uniformly positive or negative treatment effects.
\item \code{rdq.bandwidth} implements two bandwidth selection rules:
the cross-validation bandwidth and the MSE optimal bandwidth.
\item \code{plot.qte} generates figures summarizing the treatment effects along with their confidence bands.
}
}
\references{
Zhongjun Qu, Jungmo Yoon, Pierre Perron (2024), "Inference on Conditional Quantile
Processes in Partially Linear Models with Applications to the Impact of Unemployment Benefits,"
The Review of Economics and Statistics; https://doi.org/10.1162/rest_a_01168

Zhongjun Qu and Jungmo Yoon (2019), "Uniform Inference on Quantile Effects
under Sharp Regression Discontinuity Designs," Journal of Business and Economic Statistics,
37(4), 625–647; https://doi.org/10.1080/07350015.2017.1407323
}
\author{
\itemize{
\item Zhongjun Qu \href{mailto:qu@bu.edu}{qu@bu.edu}
\item Jungmo Yoon \href{mailto:jmyoon@hanyang.ac.kr}{jmyoon@hanyang.ac.kr}
}
}
\keyword{external}
