% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_portfolios.R
\name{random_portfolios_v1}
\alias{random_portfolios_v1}
\title{generate an arbitary number of constrained random portfolios}
\usage{
random_portfolios_v1(rpconstraints, permutations = 100, ...)
}
\arguments{
\item{rpconstraints}{an object of type "constraints" specifying the constraints for the optimization, see \code{\link{constraint}}}

\item{permutations}{integer: number of unique constrained random portfolios to generate}

\item{\dots}{any other passthru parameters}
}
\value{
matrix of random portfolio weights
}
\description{
repeatedly calls \code{\link{randomize_portfolio}} to generate an 
arbitrary number of constrained random portfolios.
}
\examples{
rpconstraint<-constraint_v1(assets=10, 
                         min_mult=-Inf, 
                         max_mult=Inf, 
                         min_sum=.99, 
                         max_sum=1.01, 
                         min=.01, 
                         max=.4, 
                         weight_seq=generatesequence())
                         
rp<- random_portfolios_v1(rpconstraints=rpconstraint,permutations=1000)
head(rp)
}
\seealso{
\code{\link{constraint}}, \code{\link{objective}}, \code{\link{randomize_portfolio}}
}
\author{
Peter Carl, Brian G. Peterson, (based on an idea by Pat Burns)
}
