% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PerMallows.R
\name{rgmm}
\alias{rgmm}
\title{Sample a Generalized Mallows Model}
\usage{
rgmm(n, sigma0, theta, dist.name = "kendall", sampling.method = "multistage")
}
\arguments{
\item{n}{the number of permutations to be generated}

\item{sigma0}{central permuation of the GMM}

\item{theta}{dispersion parameter vector of the GMM}

\item{dist.name}{optional used name of the distance used in the GMM. One of: kendall (default), cayley, hamming}

\item{sampling.method}{optional name of the sampling algorithm. One of: multistage, gibbs (default)}
}
\value{
A matrix contaning a sample of permutations from the specified ditribution
}
\description{
Generate a sample of n permutations from a Generalized Mallows Model (GMM).
}
\examples{
rgmm(2,c(1,2,3,4,5),c(1,1,1,1),"kendall", "multistage")
rgmm(2,c(1,2,3,4,5),c(1,1,1,1),"cayley", "multistage")
rgmm(2,c(1,2,3,4,5),c(1,1,1,1,1),"hamming", "multistage")
rgmm(2,c(1,2,3,4,5),c(1,1,1,1),"cayley", "gibbs")
rgmm(2,c(1,2,3,4,5),c(1,1,1,1,1),"hamming", "gibbs")
}
\references{
"Ekhine Irurozki, Borja Calvo, Jose A. Lozano (2016). PerMallows: An R Package for Mallows and Generalized Mallows Models. Journal of Statistical Software, 71(12), 1-30. doi:10.18637/jss.v071.i12"
}
