% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCategories.R
\name{addCategories}
\alias{addCategories}
\title{Categorize a numeric variable}
\usage{
addCategories(
  x,
  variable,
  categories,
  missingCategoryValue = "None",
  overlap = FALSE,
  includeLowerBound = TRUE,
  includeUpperBound = TRUE,
  name = NULL
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{variable}{Target variable that we want to categorize.}

\item{categories}{List of lists of named categories with lower and upper
limit.}

\item{missingCategoryValue}{Value to assign to those individuals not in
any named category. If NULL or NA, missing values will not be changed.}

\item{overlap}{TRUE if the categories given overlap.}

\item{includeLowerBound}{Whether to include the lower bound in the group.}

\item{includeUpperBound}{Whether to include the upper bound in the group.}

\item{name}{Name of the new table, if NULL a temporary table is returned.}
}
\value{
The x table with the categorical variable added.
}
\description{
Categorize a numeric variable
}
\examples{
\donttest{
cdm <- mockPatientProfiles()

result <- cdm$cohort1 |>
  addAge() |>
  addCategories(
    variable = "age",
    categories = list("age_group" = list(
      "0 to 39" = c(0, 39), "40 to 79" = c(40, 79), "80 to 150" = c(80, 150)
    ))
  )
mockDisconnect(cdm = cdm)
}
}
