% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addConceptIntersect.R
\name{addConceptIntersectCount}
\alias{addConceptIntersectCount}
\title{It creates column to indicate the count overlap information between a table
and a concept}
\usage{
addConceptIntersectCount(
  x,
  conceptSet,
  indexDate = "cohort_start_date",
  censorDate = NULL,
  window = list(c(0, Inf)),
  targetStartDate = "cohort_start_date",
  targetEndDate = NULL,
  order = "first",
  nameStyle = "{concept_name}_{window_name}"
)
}
\arguments{
\item{x}{Table with individuals in the cdm}

\item{conceptSet}{Concept set list.}

\item{indexDate}{Variable in x that contains the date to compute the
intersection.}

\item{censorDate}{whether to censor overlap events at a date column of x}

\item{window}{window to consider events in.}

\item{targetStartDate}{date of reference in cohort table, either for start
(in overlap) or on its own (for incidence)}

\item{targetEndDate}{date of reference in cohort table, either for end
(overlap) or NULL (if incidence)}

\item{order}{last or first date to use for date/time calculations.}

\item{nameStyle}{naming of the added column or columns, should include
required parameters}
}
\value{
table with added columns with overlap information
}
\description{
It creates column to indicate the count overlap information between a table
and a concept
}
\examples{
\donttest{
library(PatientProfiles)
library(CodelistGenerator)

cdm <- mockPatientProfiles()
# result <- cdm$cohort1 \%>\%
#   addConceptIntersectCount(
#     conceptSet = getDrugIngredientCodes(cdm, "acetaminophen")
#  ) \%>\%
#   dplyr::collect()
}

}
