% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getParamTypes}
\alias{getParamTypes}
\title{Returns type information for a parameter set.}
\usage{
getParamTypes(par.set, df.cols = FALSE, df.discretes.as.factor = TRUE,
  use.names = FALSE, with.nr = TRUE)
}
\arguments{
\item{par.set}{[\code{\link{ParamSet}}]\cr
Parameter set.}

\item{df.cols}{[\code{logical(1)}]\cr
If \code{FALSE} simply return the parameter types in the set,
i.e., \code{par$type}.
If \code{TRUE}, convert types so they correspond to R types of a data.frame
where values of this set might be stored.
This also results in replication of output types for
vector parameters.
Default is \code{FALSE}.}

\item{df.discretes.as.factor}{[\code{logical(1)}]\cr
If \code{df.cols} is \code{TRUE}:
Should type for discrete params be \code{facor} or \code{character}?
Default is \code{TRUE}.}

\item{use.names}{[\code{logical(1)}]\cr
Name the result vector?
Default is \code{FALSE}.}

\item{with.nr}{[\code{logical(1)}]\cr
Should number from 1 to length be appended to name?
Only used if \code{use.name} and \code{df.cols} are \code{TRUE}.
Default is \code{TRUE}.}
}
\value{
[\code{character}].
}
\description{
Returns type information for a parameter set.
}

