% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelMatchObject.R
\name{plot.PanelMatch}
\alias{plot.PanelMatch}
\title{Plot the distribution of the sizes of matched sets.}
\usage{
\method{plot}{PanelMatch}(
  x,
  ...,
  border = NA,
  col = "grey",
  ylab = "Frequency of Size",
  xlab = "Matched Set Size",
  lwd = NULL,
  main = "Distribution of Matched Set Sizes",
  freq = TRUE,
  include.empty.sets = FALSE
)
}
\arguments{
\item{x}{a \code{PanelMatch} object}

\item{...}{optional arguments to be passed to \code{hist()}}

\item{border}{default is NA. This is the same argument as the standard argument for \code{hist()}}

\item{col}{default is "grey". This is the same argument as the standard argument for \code{hist()}}

\item{ylab}{default is "Frequency of Size". This is the same argument as the standard argument for \code{hist()}}

\item{xlab}{default is "Matched Set Size". This is the same argument as the standard argument for \code{hist()}}

\item{lwd}{default is NULL. This is the same argument as the standard argument for \code{hist()}}

\item{main}{default is "Distribution of Matched Set Sizes". This is the same argument as the standard argument for \code{hist}}

\item{freq}{default is TRUE. See \code{freq} argument in \code{hist()} function for more.}

\item{include.empty.sets}{logical value indicating whether or not empty sets should be included in the histogram. default is FALSE. If FALSE, then empty sets will be noted as a separate vertical bar at x = 0. If TRUE, empty sets will be included as normal sets.}
}
\description{
A plot method for creating a histogram of the distribution of the sizes of matched sets.
This method accepts all standard optional \code{hist} arguments via the \code{...} argument.
By default, empty matched sets (treated units that could not be
matched with any control units) are noted as a vertical bar at x = 0 and not included in the
regular histogram. See the \code{include.empty.sets} argument for more information about this. If the quantity of interest is ATE, a plot will be returned for the matched sets associated with the att and the atc.
}
\examples{
dem.sub <- dem[dem[, "wbcode2"] <= 100, ]
dem.sub.panel <- PanelData(dem.sub, "wbcode2", "year", "dem", "y")
PM.results <- PanelMatch(panel.data = dem.sub.panel,
                         lag = 4, 
                         refinement.method = "mahalanobis",
                         match.missing = TRUE,
                         covs.formula = ~ I(lag(tradewb, 1:4)) + I(lag(y, 1:4)),
                         size.match = 5, qoi = "att",
                         lead = 0:4, forbid.treatment.reversal = FALSE)
plot(PM.results)
plot(PM.results, include.empty.sets = TRUE)

}
