% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sipsLM.R
\name{sips.LM}
\alias{sips.LM}
\title{Sips Isotherm Linear Analysis}
\usage{
sips.LM(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the linear regression, parameters for Sips isotherm, and model error
analysis
}
\description{
It is the most applicable to use in the monolayer adsorption
isotherm model amongst the three-parameter isotherm models and is also valid
for the prediction of heterogeneous adsorption systems as well as localized
adsorption with no interactions occurring between adsorbates.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
sips.LM(Ce,Qe)
}
\references{
Sips, R. (1948) <doi:10.1063/1.1746922> On the structure of a catalyst
surface. The Journal of Chemical Physics, 16(5), 490-495.
}
\author{
Keith T. Ostan

Chester C. Deocaris
}
