% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kiselevLM.R
\name{kiselev.LM}
\alias{kiselev.LM}
\title{Kiselev Isotherm Linear Analysis}
\usage{
kiselev.LM(theta, Ce)
}
\arguments{
\item{theta}{is the fractional surface coverage}

\item{Ce}{the numerical value for equilibrium capacity}
}
\value{
the linear regression, parameters for the Kiselev isotherm, and
model error analysis
}
\description{
It is also known as localized monomolecular layer model and
is only valid for surface coverage theta > 0.68.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607,
0.80435, 1.10327, 1.58223)
theta  <- c(0.1972984, 0.3487013, 0.6147560, 0.7432401, 0.8854408,
0.8900708, 0.9106746, 0.9106746, 0.9611422)
kiselev.LM(theta, Ce)
}
\references{
Kiselev, A. V. (1958). "Vapor adsorption in the formation of
adsorbate molecule complexes on the surface," Kolloid Zhur, vol. 20, pp. 338-348.
}
\author{
Paul Angelo C. Manlapaz

Chester C. Deocaris
}
