% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FS3analysis.R
\name{FS3analysis}
\alias{FS3analysis}
\title{Fritz-Schlunder Three Parameter Non-Linear Analysis}
\usage{
FS3analysis(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the nonlinear regression, parameters for Fritz-Schlunder three Parameter
isotherm, and model error analysis
}
\description{
The Fritz-Schlunder isotherm model is an empirical expression that
can fit over an extensive range of experimental results as a result of the huge
number of coefficients in their adsorption isotherm.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
FS3analysis(Ce,Qe)
}
\references{
Fritz, W., & Schluender, E. U. (1974) <doi:10.1016/0009-2509(74)80128-4> Simultaneous adsorption
equilibria of organic solutes in dilute aqueous solutions on activated carbon.
Chemical Engineering Science, 29(5), 1279-1282.
}
\author{
Jemimah Christine L. Mesias

Chester C. Deocaris
}
