% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hilldeboeranalysis.r
\name{hilldeboeranalysis}
\alias{hilldeboeranalysis}
\title{Hill-Deboer Isotherm Non-linear Analysis}
\usage{
hilldeboeranalysis(theta, Ce, t)
}
\arguments{
\item{theta}{the numerical value for the surface converage / fractional coverage}

\item{Ce}{the numerical value for the equilibrium capacity}

\item{t}{the numerical value for the temperature of the adsorption experimentation in Kelvin}
}
\description{
Hill-Deboer isotherm model describes as a case where there is mobile adsorption as well as lateral interaction among molecules.
}
\examples{
Ce <- c(0.39, 0.74, 1.19, 1.63, 2.03, 2.51, 2.96, 3.46, 3.9, 4.35)
theta <- c(0.051, 0.12, 0.14, 0.17, 0.21, 0.22, 0.24, 0.24, 0.27, 0.29)
hilldeboeranalysis(theta, Ce, 298)
}
\references{
Ayawei, N., Ebelegi, A.N., & Wankasi, D. (2017). Modelling and Interpretation of Adsorption Isotherms. Journal of Chemistry, 2017, 1-11. doi 10.115520173039817

Qing Shao and Carol K Hall (2016). Protein adsorption on nanoparticles model development using computer simulation. Journal of Physics Condensed Matter

Oualid Hamdaouia, Emmanuel Naffrechoux (2007). Modeling of adsorption isotherms of phenol andchlorophenols onto granular activated carbonPart I. Two-parameter models and equations allowing determination of thermodynamic parameters
}
\author{
Benz L. Rivera

Jeff Ryan S. Magalong

C.C. Deocaris
}
