\encoding{utf8}


\name{CompareAS16}

\alias{CompareAS16}

\title{Comparing bit vectors generated by CreateAS16}
\usage{
CompareAS16(IDA, dataA, IDB, dataB, password, t = 0.85)
}
\description{
Comparing all elements of two vectors of records with each other using Armknechts & Schnells methods "create" and "compare".
}
\arguments{
  \item{IDA}{A character vector or integer vector containing the IDs of the first data.frame.}
  \item{dataA}{A character vector containing the bit vectors that are to be created by Armknechts method "create".}
  \item{IDB}{A character vector or integer vector containing the IDs of the second data.frame.}
  \item{dataB}{A character vector containing the bit vectors that are to be  created by Armknechts method "create".}
  \item{password}{A string containing the password used in the method "create".}
  \item{t}{A float containing the lower Tanimoto similarity threshold.}
}

\details{
Two bit vectors generated by \code{\link{CreateAS16}} are compared as described in the original publication.
}

\value{
The function returns a data.frame with four columns containing all ID-pairs of all bit vectors, the estimated Tanimoto similarity and the classification (links/non-links).
}
\source{
Armknecht, F., Schnell, R. (unpublished): Privacy Preserving Record Linkage Based on
Bloom Filters and Codes. Working Paper.
}

\examples{
# Load test data
testFile <- file.path(path.package("PPRL"), "extdata/testdata.csv")
testData <- read.csv(testFile, head = FALSE, sep = "\t",
  colClasses = "character")

# Create Bloom Filter
testData <- CreateBF(ID = testData$V1, testData$V7, k = 20, padding = 1,
  q = 2, l = 1000, password = "(H]$6Uh*-Z204q")

# Optional: Create the new Bloom filter, the output of this function is just
# to see the created bit vectors, it is not the input of CompareAS16.
testAS <- CreateAS16(testData$ID, testData$CLKs, password = "khäuds")

# Compare bit vectcors, input is not the out put of CreateAS16,
# but the original Bloom Filters. CreateAS16 is executated in CompareAS16.
res <- CompareAS16(testData$ID, testData$CLKs, testData$ID, testData$CLKs,
  password = "khäuds", t = 0.85)

}
\seealso{
  
  \code{\link{CreateAS16}}
}
