% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTest.R
\name{MTest}
\alias{MTest}
\alias{MTest.default}
\alias{MTest.formula}
\title{Extended One-Sided Studentised Range Test}
\usage{
MTest(x, ...)

\method{MTest}{default}(x, g, ...)

\method{MTest}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Nashimoto-Wright's extended one-sided studentised range
test against an ordered alternative for normal data
with equal variances.

This test is an extension of Hayter's OSRT
(see \code{\link{osrtTest}}) by
applying a simple order restriction of
\eqn{\mu_{m'} - \mu_m \le \mu_j - \mu_i \le \
\mu_{l'} - \mu_{l}} for any \eqn{l \le i \le m}
and \eqn{m' \le j \le l'}. It tests all-pairs
\eqn{\mathrm{H}_{ij}: \mu_i \ge \mu_j} against
\eqn{\mathrm{A}_{ij}: \mu_i < \mu_j$ for any $1 \le i < j \le k}.
}
\examples{
MTest(weight ~ group, data = PlantGrowth)
}
\references{
Nashimoto, K., Wright, F.T., (2005) Multiple comparison procedures
for detecting differences in simply ordered means.
\emph{Comput. Statist. Data Anal.} \bold{48}, 291--306.
}
\concept{
AllPairsComparison
}
\keyword{htest}
