% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile_sim_cpp.R
\name{compile_sim_cpp}
\alias{compile_sim_cpp}
\title{Compile ODE model to c++ function}
\usage{
compile_sim_cpp(
  code,
  dose_code,
  pk_code,
  size,
  p,
  cpp_show_code,
  code_init = NULL,
  state_init = NULL,
  declare_variables = NULL,
  variables = NULL,
  covariates = NULL,
  obs = NULL,
  dose = NULL,
  iov = NULL,
  compile = TRUE,
  verbose = FALSE,
  as_is = FALSE
)
}
\arguments{
\item{code}{C++ code ODE system}

\item{dose_code}{C++ code per dose event}

\item{pk_code}{C++ code per any event (similar to $PK)}

\item{size}{size of ODE system}

\item{p}{parameters (list)}

\item{cpp_show_code}{show output c++ function?}

\item{code_init}{code for initialization of state}

\item{state_init}{state init vector}

\item{declare_variables}{variable declaration for all required variables (including user-specified)}

\item{variables}{only the user-specified variables}

\item{covariates}{covariates specification}

\item{obs}{observation specification}

\item{dose}{dose specification}

\item{iov}{iov specification}

\item{compile}{compile or not?}

\item{verbose}{show more output}

\item{as_is}{use C-code as-is, don't substitute line-endings or shift indices}
}
\value{
List containing ODE definition in C++ code and simulation function
}
\description{
Compile ODE model to c++ function
}
