% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repgrid-basicops.r
\name{bindConstructs}
\alias{bindConstructs}
\title{Concatenate the constructs of two or more grids.}
\usage{
bindConstructs(..., index = FALSE)
}
\arguments{
\item{...}{One or more repgrid objects or a list containing
\code{repgrid} object.}

\item{index}{TODO. Logical (default \code{TRUE}). Whether to add an index at the end
of each construct name so it remains clear from which grid each
construct came.}
}
\value{
\code{repgrid} object with concatenated constructs.
}
\description{
I.e. the constructs are combined to form one long grid.
The girds must have the same set of elements and an identical
scale range. The order of the elements may differ.
}
\details{
This function can be used in order to analyze multiple grids
as one 'big grid' (eg. Slater, 1977, chap. 11).
}
\examples{

a <- randomGrid()
b <- randomGrid()
elements(b) <- rev(elements(a)) # reverse elements
bindConstructs(a, b)
bindConstructs(a, b, a)

# using lists of repgrid objects
bindConstructs(a, list(a, b))

}
\references{
Slater, P. (1977). \emph{The measurement of intrapersonal space
by grid technique}. London: Wiley.
}
\keyword{internal}
