% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TAR.r
\name{tvAR}
\alias{tvAR}
\title{Estimate Time-Varying Coefficient AR Models}
\usage{
tvAR(x, lags = c(1), include.mean = TRUE)
}
\arguments{
\item{x}{a time series of data.}

\item{lags}{the lagged variables used, e.g. lags=c(1,3) means lag-1 and lag-3 are used as regressors.
It is more flexible than specifying an order.}

\item{include.mean}{a logical value indicating whether the constant terms are included.}
}
\value{
\code{trAR} function returns the value from function \code{dlmMLE}.
}
\description{
Estimate time-varying coefficient AR models.
}
\examples{
t=50
x=rnorm(t)
phi1=matrix(0.4,t,1)
for (i in 2:t){
   phi1[i]=0.7*phi1[i-1]+rnorm(1,0,0.1)
	x[i]=phi1[i]*x[i-1]+rnorm(1)
}
est=tvAR(x,1)
}
