% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{est_cfar}
\alias{est_cfar}
\title{Estimation of a CFAR Process}
\usage{
est_cfar(f, p = 3, df_b = 10, grid = 1000)
}
\arguments{
\item{f}{the functional time series.}

\item{p}{CFAR order.}

\item{df_b}{the degrees of freedom for natural cubic splines. Default is 10.}

\item{grid}{the number of gird points used to construct the functional time series and noise process. Default is 1000.}
}
\value{
The function returns a list with components:
\item{phi_coef}{estimated spline coefficients for convolutional function values, a (2*grid+1)-by-p matrix.}
\item{phi_func}{estimated convolutional function(s), a (df_b+1)-by-p matrix.}
\item{rho}{estimated rho for O-U process (noise process).}
\item{sigma}{estimated sigma for O-U process (noise process).}
}
\description{
Estimation of a CFAR process.
}
\references{
Liu, X., Xiao, H., and Chen, R. (2016) Convolutional autoregressive models for functional time series. \emph{Journal of Econometrics}, 194, 263-282.
}
