% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npcox.R
\name{npcox}
\alias{npcox}
\title{Nonparametric and semiparametric Cox regression model.}
\usage{
npcox(cva, delta, obstime, SE = FALSE, bandwidth = FALSE, resamp = 100)
}
\arguments{
\item{cva}{Covariate Z in h(t) = h0(t)exp(b(t)'Z)}

\item{delta}{Right censoring indicator for the model}

\item{obstime}{The observed time = min(censoring time, observed failure time)}

\item{SE}{Whether or not the estimation of standard error through resampling method will be done. The default value is FALSE.}

\item{bandwidth}{Bandwidth for kernel function, which can be specified. The default value is FALSE and can be selected through least prediction error over all subjects.}

\item{resamp}{Number of resampling for estimation of pointwise standard error. The default value is 100.}
}
\value{
a list that contain the estimation result of temporal coefficients, standard error estimation, selected or predesigned bandwidth, dataset, unconverged time points.
}
\description{
Estimation of proportional hazards (PH) model with time-varying coefficients.
}
\details{
This is some description of this function.

'npcox' function is designed for PH model with time-varying coefficients, h(t) = h0(t)exp(b(t)'Z), providing estimation of b(t) and its pointwise standard errors on [bandwidth, max(obstime)-badwidth].
}
\examples{
data(pbc)
pbc = pbc[(pbc$time < 3000) & (pbc$time > 800), ] 
Z   = pbc[,c("age","edema")]
colnames(Z) = c("age","edema")
del = pbc$status
tim = pbc$time
res = npcox(cva = Z,delta = del, obstime = tim, bandwidth = 500)
}
