% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCmisc.R
\name{getRepositories}
\alias{getRepositories}
\title{Detect all available R repositories.}
\usage{
getRepositories(ind = NULL, table = FALSE)
}
\arguments{
\item{ind}{index, same as for 'setRepositories', if NULL this function returns all available
repositories, or if an index, returns a subset.}

\item{table}{logical, if TRUE, return a table of information, else just return the URLs, 
which are the required input for the 'repos' argument for relevant functions, 
e.g, available.packages() or search.cran()}
}
\value{
list of repositories with URLS, note that it is the URL that works best for
use for passing a value for 'repos' to various functions.
}
\description{
In addition to the default CRAN repository, there are other repositories such
as R-Forge, Omegahat, and bioConductor (which is split in to software, annotation,
experiments and extras). This function allows you to retrieve which are available.
This function complements (and takes code from) utils::setRepositories(), which
will just set, not return which are available, but see there for more information
about how this works. Detecting the available repositories can be useful to precede
a call to setRepositories, and allows you to utilise these repositories without
calling setRepositories (which is hard to reverse). This function can be used to
expand the search space of the function search.cran() to include bioconductor packages.
}
\examples{
require(BiocInstaller)
repos <- "http://cran.ma.imperial.ac.uk/" # OR: repos <- getOption("repos")
getRepositories(table=TRUE) # shows all available
getRepositories(2:5,FALSE) # returns index for all bioconductor repositories (on my system at least)
search.cran("genoset",repos=getRepositories(1)) # does not find this bioconductor package on CRAN
search.cran("genoset",repos=getRepositories()) # should now, because all repositories are used
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}

