% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{render}
\alias{render}
\title{Render a HTML report from \link{summarise} or \link{normalise}}
\usage{
render(nacho_object, colour = "CartridgeID",
  output_file = "NACHO_QC.html", output_dir = ".", size = 0.5,
  show_legend = TRUE, clean = TRUE)
}
\arguments{
\item{nacho_object}{[\link{list}] List obtained from \link{summarise} or \link{normalise}.}

\item{colour}{[\link{character}] Character string of the column in \code{ssheet_csv}
or more generally in \code{nacho_object$nacho} to be used as grouping colour.}

\item{output_file}{[\link{character}] The name of the output file.}

\item{output_dir}{[\link{character}] The output directory for the rendered output_file.
This allows for a choice of an alternate directory to which the output file should be written
(the default output directory is the working directory, \emph{i.e.}, \code{.}).
If a path is provided with a filename in \code{output_file} the directory specified here will take precedence.
Please note that any directory path provided will create any necessary directories if they do not exist.}

\item{size}{[\link{numeric}] A \code{numeric} controlling point size (\link{geom_point} or \link{geom_beeswarm})
or line size (\link{geom_line}).}

\item{show_legend}{[\link{logical}] Boolean to indicate whether the plot legends should
be plotted (\code{TRUE}) or not (\code{FALSE}). Default is \code{TRUE}.}

\item{clean}{[\link{logical}] Boolean to indicate whether the Rmd and Rdata file used to produce the HTML report
are removed from \code{output_dir}. Default is \code{TRUE}.}
}
\description{
This function create a \code{Rmarkdown} script and render it as a HTML document.
The HTML document is a quality-control report using all the metrics from \link{visualise}
based on recommendations from NanoString.
}
\examples{

if (interactive()) {
  data(GSE74821)
  render(GSE74821)
}

}
