% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grindr-drawers.R
\name{drawers}
\alias{drawers}
\alias{draw_polygon}
\alias{draw_outline}
\alias{draw_outlines}
\alias{draw_points}
\alias{draw_landmarks}
\alias{draw_lines}
\alias{draw_centroid}
\alias{draw_curve}
\alias{draw_curves}
\alias{draw_firstpoint}
\alias{draw_axes}
\alias{draw_ticks}
\alias{draw_labels}
\alias{draw_links}
\alias{draw_title}
\title{grindr drawers for shape plots}
\usage{
draw_polygon(
  coo,
  f,
  col = par("fg"),
  fill = NA,
  lwd = 1,
  lty = 1,
  transp = 0,
  pal = pal_qual,
  ...
)

draw_outline(
  coo,
  f,
  col = par("fg"),
  fill = NA,
  lwd = 1,
  lty = 1,
  transp = 0,
  pal = pal_qual,
  ...
)

draw_outlines(
  coo,
  f,
  col = par("fg"),
  fill = NA,
  lwd = 1,
  lty = 1,
  transp = 0,
  pal = pal_qual,
  ...
)

draw_points(
  coo,
  f,
  col = par("fg"),
  cex = 1/2,
  pch = 20,
  transp = 0,
  pal = pal_qual,
  ...
)

draw_landmarks(
  coo,
  f,
  col = par("fg"),
  cex = 1/2,
  pch = 20,
  transp = 0,
  pal = pal_qual,
  ...
)

draw_lines(
  coo,
  f,
  col = par("fg"),
  lwd = 1,
  lty = 1,
  transp = 0,
  pal = pal_qual,
  ...
)

draw_centroid(
  coo,
  f,
  col = par("fg"),
  pch = 3,
  cex = 0.5,
  transp = 0,
  pal = pal_qual,
  ...
)

draw_curve(
  coo,
  f,
  col = par("fg"),
  lwd = 1,
  lty = 1,
  transp = 0,
  pal = pal_qual,
  ...
)

draw_curves(
  coo,
  f,
  col = par("fg"),
  lwd = 1,
  lty = 1,
  transp = 0,
  pal = pal_qual,
  ...
)

draw_firstpoint(
  coo,
  f,
  label = "^",
  col = par("fg"),
  cex = 3/4,
  transp = 0,
  pal = pal_qual,
  ...
)

draw_axes(coo, col = "#999999", lwd = 1/2, ...)

draw_ticks(coo, col = "#333333", cex = 3/4, lwd = 3/4, ...)

draw_labels(coo, labels = 1:nrow(coo), cex = 1/2, d = 1/20, ...)

draw_links(
  coo,
  f,
  links,
  col = "#99999955",
  lwd = 1/2,
  lty = 1,
  transp = 0,
  pal = pal_qual,
  ...
)

draw_title(
  coo,
  main = "",
  sub = "",
  cex = c(1, 3/4),
  font = c(2, 1),
  padding = 1/200,
  ...
)
}
\arguments{
\item{coo}{\code{matrix} of 2 columns for (x, y) coordinates}

\item{f}{an optionnal factor specification to feed. See examples and vignettes.}

\item{col}{color (hexadecimal) to draw components}

\item{fill}{color (hexadecimal) to draw components}

\item{lwd}{to draw components}

\item{lty}{to draw components}

\item{transp}{\code{numeric} transparency (default:0, min:0, max:1)}

\item{pal}{a palette to use if no col/border/etc. are provided. See \verb{[palettes]}}

\item{...}{additional options to feed core functions for each drawer}

\item{cex}{to draw components ((\code{c(2, 1)} by default) for \code{draw_title})}

\item{pch}{to draw components}

\item{label}{to indicate first point}

\item{labels}{\code{character} name of labels to draw (defaut to \code{1:nrow(coo)})}

\item{d}{\code{numeric} proportion of \code{d(centroid-each_point)} to add when centrifugating landmarks}

\item{links}{\code{matrix} of links to use to draw segments between landmarks. See \code{wings$ldk} for an example}

\item{main}{\code{character} title (empty by default)}

\item{sub}{\code{character} subtitle (empty by default)}

\item{font}{\code{numeric} to feed \link{text} (\code{c(2, 1)} by default)}

\item{padding}{\code{numeric} a fraction of the graphical window (\code{1/200} by default)}
}
\value{
a drawing layer
}
\description{
Useful drawers for building custom
shape plots using the grindr approach. See examples and vignettes.
}
\note{
This approach will (soon) replace \link{coo_plot} and friends in further versions.
All comments are welcome.
}
\examples{
bot[1] \%>\% paper_grid() \%>\% draw_polygon()
olea \%>\% paper_chess \%>\% draw_lines(~var)

hearts[240] \%>\% paper_white() \%>\% draw_outline() \%>\%
  coo_sample(24) \%>\% draw_landmarks \%>\% draw_labels() \%>\%
  draw_links(links=replicate(2, sample(1:24, 8)))

bot \%>\%
    paper_grid() \%>\%
    draw_outlines() \%>\%
    draw_title("Alcohol abuse \nis dangerous for health", "Drink responsibly")
}
\seealso{
grindr_layers

Other grindr: 
\code{\link{layers_morphospace}},
\code{\link{layers}},
\code{\link{mosaic_engine}()},
\code{\link{papers}},
\code{\link{pile}()},
\code{\link{plot_LDA}()},
\code{\link{plot_NMDS}()},
\code{\link{plot_PCA}()}
}
\concept{grindr}
